/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;

public class ConsoleInputStream
extends InputStream
implements Observer {
    private LinkedList<Byte> buffer = new LinkedList();

    @Override
    public int read() throws IOException {
        return this.getFromBuffer();
    }

    @Override
    public void update(Observable observable, Object info) {
        this.addToBuffer(String.valueOf((String)info) + "\r\n");
    }

    private synchronized void addToBuffer(String info) {
        byte[] bytes = info.getBytes();
        int i = 0;
        while (i < bytes.length) {
            this.buffer.addLast(bytes[i]);
            ++i;
        }
        this.notifyAll();
    }

    private synchronized int getFromBuffer() {
        try {
            while (this.buffer.isEmpty()) {
                this.wait();
            }
            byte ch = this.buffer.getFirst();
            this.buffer.removeFirst();
            return ch;
        }
        catch (InterruptedException e) {
            return -1;
        }
    }

    @Override
    public int available() throws IOException {
        return this.getBufferLength();
    }

    private synchronized int getBufferLength() {
        return this.buffer.size();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int read_count = this.internalRead(b, off, len);
        return read_count;
    }

    private synchronized int internalRead(byte[] b, int off, int len) {
        try {
            while (this.buffer.isEmpty()) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int read_count = len < this.buffer.size() ? len : this.buffer.size();
        int i = 0;
        while (i < read_count) {
            b[off + i] = this.buffer.getFirst();
            this.buffer.removeFirst();
            ++i;
        }
        return read_count;
    }
}

